#ifndef ATARICOMMEMORY_H
#define ATARICOMMEMORY_H
/*
   AtariComMemory - helper class for merging COM file blocks

   Copyright (C) 2008 Matthias Reichl <hias@horus.com>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "ComBlock.h"

class AtariComMemory : public RefCounted {
public:
	AtariComMemory();
	virtual ~AtariComMemory();

	void Clear();

	bool WriteComBlockToMemory(const RCPtr<ComBlock>& blk);

	bool ContainsData() const;

	RCPtr<ComBlock> AsComBlock() const;

private:
	enum { eMemSize = 65536 };

	bool fContainsData;
	uint8_t fData[eMemSize];
	unsigned int fMinAddress;
	unsigned int fMaxAddress;
};

inline bool AtariComMemory::ContainsData() const
{
	return fContainsData;
}

#endif
